	function genmakefile(dir, prefix, firsrc, tbsrc)
	%genmakefile(dir, prefix, firsrc, tbsrc)
	%
	%Generates a makefile with targets to compile, simulate and synthesize 
	%generated FIR files. Also generates dc.cmd for synthesis with design
	%compiler.
	%
	%Arguments:
	%  dir - directory to generate files in
	%  prefix - name (not used)
	%  firsrc - bit-level sources
	%  tbsrc - test-bench sources
	
	%Copyright 2008, 2010 Anton Blad
	%
	%This file is part of firgen.
	%
	%firgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	%
	%firgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	%
	%You should have received a copy of the GNU General Public License
	%along with firgen.  If not, see <http://www.gnu.org/licenses/>
	
	firgenconf;
	
	fn = strcat(dir, '/', 'Makefile');
	
	fid = fopen(fn, 'w+');
	
	fprintf(fid, 'usage:\n');
	fprintf(fid, '\techo "@make init: initialize simulation environment"\n');
	fprintf(fid, '\techo "@make compile: compile files"\n');
	fprintf(fid, '\techo "@make compiletb: compile testbench"\n');
	fprintf(fid, '\techo "@make synth: synthesize"\n');
	fprintf(fid, '\n');
	fprintf(fid, 'init:\n');
	fprintf(fid, '\t%s\n', SIM_INIT);
	fprintf(fid, '\n');
	fprintf(fid, 'compile:\n');
	for f = 1:length(firsrc)
		cfn = firsrc{f};
		fprintf(fid, '\t%s %s\n', SIM_COMPILE, cfn);
	end
	fprintf(fid, '\n');
	
	fprintf(fid, 'compiletb: compile\n');
	for f = 1:length(tbsrc)
		cfn = tbsrc{f};
		fprintf(fid, '\t%s %s\n', SIM_COMPILE, cfn);
	end
	fprintf(fid, '\n');
	
	fprintf(fid, 'synth:\n');
	fprintf(fid, '\t%s\n', SYNTH_CMD);
	
	fclose(fid);
	
	vhdlfirstr = sprintf('%s ', firsrc{:});
	
	fn = strcat(dir, '/', 'dc.cmd');
	fid = fopen(fn, 'w+');
	fprintf(fid, 'redirect -tee dc.out {\n');
	fprintf(fid, '\n');
	fprintf(fid, '  set vhdlfiles {%s}\n', vhdlfirstr);
	fprintf(fid, '  foreach f $vhdlfiles {\n');
	fprintf(fid, '          if {[analyze -format vhdl $f] != 1} {\n');
	fprintf(fid, '                  quit\n');
	fprintf(fid, '          }\n');
	fprintf(fid, '  }\n');
	fprintf(fid, '\n');
	fprintf(fid, '  if {[elaborate fir] != 1} {\n');
	fprintf(fid, '          quit\n');
	fprintf(fid, '  }\n');
	fprintf(fid, '\n');
	fprintf(fid, '  create_clock -period 1.6667 clk\n');
	fprintf(fid, '\n');
	fprintf(fid, '  set_load 0.01 [all_outputs]\n');
	fprintf(fid, '  set_driving_cell -lib_cell "IVSVTX1" [all_inputs]\n');
	fprintf(fid, '  set_drive 0 clk\n');
	fprintf(fid, '\n');
	fprintf(fid, '  set_input_delay 0.0 [all_inputs] -clock clk\n');
	fprintf(fid, '  set_output_delay 0.0 [all_outputs] -clock clk\n');
	fprintf(fid, '\n');
	fprintf(fid, '  set_max_total_power 0.0 mW\n');
	fprintf(fid, '\n');
	fprintf(fid, '  set_switching_activity [all_inputs] -static_probability 0.5 -toggle_rate 0.5 -period 1.6667\n');
	fprintf(fid, '  set_switching_activity clk\n');
	fprintf(fid, '  set_switching_activity reset -static_probability 1.0 -toggle_rate 0.0\n');
	fprintf(fid, '\n');
	fprintf(fid, '  check_design\n');
	fprintf(fid, '\n');
	fprintf(fid, '  if {[compile] != 1} {\n');
	fprintf(fid, '          quit\n');
	fprintf(fid, '  }\n');
	fprintf(fid, '\n');
	fprintf(fid, '  report_area\n');
	fprintf(fid, '  report_timing\n');
	fprintf(fid, '  report_power\n');
	fprintf(fid, '}\n');
	fprintf(fid, '\n');
	fprintf(fid, 'exit\n');
	fprintf(fid, '\n');
	fclose(fid);
	
